var script = new URL(document.currentScript.src);
var key  = script.searchParams.get('key');

 var mount =  document.getElementById("app-"+key);

 var link   = 'https://widget.leads.fr/widgets/news.php?key='+key;

var css = `
@import url('https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300..900;1,300..900&display=swap')

.leadsfr${key}{
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: "Rubik", sans-serif;
  }

 .leadsorg${key} {
    overflow: hidden; 
 }

.leadsorg${key} h2 {
  margin: 0;
  font-size: 16px;
  float: left; 
}


.leadsorg${key} .logo${key} {
  float: right; 
}


.leadsorg${key} img {
  width: 100px; 
  height: auto; 
}

  .card-container${key} {
    width: 80%;
    max-width: 992px; 
    margin-top: 15px;
    margin-right: auto;
    margin-left: auto;
    margin-bottom:0px;
    overflow: hidden; 
  }


  .card${key} {
    width: 31%; 
    height: 400px;
    float: left;
    margin: 1%; 
    border: none;
    background-color: #fff;
    position: relative;
    overflow: hidden;
    text-decoration: none;
  }


  .card${key} img {
    width: 100%;
    height: auto;

  }


  .card${key} h3 {
    margin: 10px;
    font-size: 16px;
    color: #4f5860;

  }


  .footer-card${key} .buttonLeads${key}{
    position: absolute;
    padding: 4px 8px;
    right: 8%;
    bottom: 3%;
    border: 1px solid #000000;
    border-radius: 3px;
    color: #000000;
    font-size: 16px;
    float: right;
    cursor: pointer;
    background: transparent;
  }


  .clearfix${key}:after {
    content: "";
    display: table;
    clear: both;
  }


  @media screen and (max-width: 768px) {
    .card${key} {
      width: 46%; 
    }
  }

  @media screen and (max-width: 480px) {
    .card${key} {
      width: 100%; 
    }
  }
`;


    head = document.head || document.getElementsByTagName('head')[0],
    style = document.createElement('style');
    style.type = 'text/css';
    var css = document.createTextNode(css);
    style.appendChild(css);
    head.appendChild(style);

   


var leadsfrDiv = document.createElement("div");
leadsfrDiv.classList.add(`leadsfr${key}`);


var cardContainerDiv = document.createElement("div");
cardContainerDiv.classList.add(`card-container${key}`, `clearfix${key}`);


var leadsorgDiv = document.createElement("div");
leadsorgDiv.classList.add(`leadsorg${key}`);

var headingDiv = document.createElement("div");
var h6Element = document.createElement("h2");
h6Element.textContent = "A découvrir";
headingDiv.appendChild(h6Element);


var logoDiv = document.createElement("div");
logoDiv.classList.add(`logo${key}`);
var logoImg = document.createElement("img");
logoImg.src = "https://assets-global.website-files.com/6442a6b63ed2323764a5a681/6481bcfe8e41f40e202b8653_Design%20sans%20titre.png";
logoImg.width = "100";
logoDiv.appendChild(logoImg);


leadsorgDiv.appendChild(headingDiv);
leadsorgDiv.appendChild(logoDiv);

cardContainerDiv.appendChild(leadsorgDiv);

//start card 
fetch(link,{
    method: 'get',
    headers: {
      "Accept": "application/json",
    }
  })
  .then(response => response.json())
  .then(json =>{

    json.forEach(ad=>{

        var cardDiv = document.createElement("a");
           cardDiv.href = ad.url;
           cardDiv.target = "_blank";
           
            cardDiv.classList.add(`card${key}`);
            // cardDiv.style.width = "18rem";


            var imgElement = document.createElement("img");
            imgElement.src = ad.image;
            imgElement.alt = ad.brand;


            var h3Element = document.createElement("h3");
            h3Element.textContent = ad.title;


            var footerCardDiv = document.createElement("div");
            footerCardDiv.classList.add(`footer-card${key}`);
            var buttonElement = document.createElement("button");
            buttonElement.classList.add(`buttonLeads${key}`);
            buttonElement.textContent =`${ad.brand} \u203A`; 
            footerCardDiv.appendChild(buttonElement);


            cardDiv.appendChild(imgElement);
            cardDiv.appendChild(h3Element);
            cardDiv.appendChild(footerCardDiv); 
            
            cardContainerDiv.appendChild(cardDiv);
    });
  
});




//end card



leadsfrDiv.appendChild(cardContainerDiv);

var clearFix = document.createElement("div");
clearFix.classList.add(`clearfix${key}`);
mount.appendChild(leadsfrDiv);
